module.exports = {
	root: true,
	env: {
		browser: true,
	},
	parser: "@typescript-eslint/parser",
	plugins: ["@typescript-eslint"],
	"extends": [
		"eslint:recommended",
		"plugin:@typescript-eslint/recommended"
	],
	parserOptions: {
		ecmaVersion: "latest",
		sourceType: "module"
	},
	rules: {
		"indent": [2, "tab"],
		"quotes": [2, "double"],
		"no-mixed-spaces-and-tabs": 2,
		"no-undef": 2,
		"no-redeclare": 2,
		"semi": [2, "always"],
		"no-func-assign": 2,
		"block-spacing": [2, "always"],
		"brace-style": [2, "1tbs", {allowSingleLine: true}],
		"comma-spacing": [2, {before: false, after: true}],
		"comma-style": [2, "last"],
		"eqeqeq": [2, "allow-null"],
		"generator-star-spacing": [2, {before: false, after: true}],
		"key-spacing": [2, {beforeColon: false, afterColon: true}],
		"keyword-spacing": [2, {before: true, after: true}],
		"new-parens": 2,
		"no-cond-assign": 2,
		"no-dupe-args": 2,
		"no-dupe-class-members": 2,
		"no-duplicate-case": 2,
		"no-empty-pattern": 2,
		"no-eval": 2,
		"no-extra-parens": [2, "functions"],
		"no-invalid-regexp": 2,
		"no-irregular-whitespace": 2,
		"no-multiple-empty-lines": [2, {max: 1}],
		"no-regex-spaces": 2,
		"no-trailing-spaces": 2,
		"no-whitespace-before-property": 2,
		"operator-linebreak": [2, "after", {overrides: {"?": "before", ":": "before"}}],
		"padded-blocks": [2, "never"],
		"semi-spacing": [2, {before: false, after: true}],
		"space-before-blocks": [2, "always"],
		"space-in-parens": [2, "never"],
		"space-infix-ops": 2,
		"space-unary-ops": [2, {words: true, nonwords: false}],
		"spaced-comment": [
			2,
			"always",
			{markers: ["global", "globals", "eslint", "eslint-disable", "*package", "!", ","]},
		],
		"template-curly-spacing": [2, "never"],
		"wrap-iife": [2, "any"],
		"yield-star-spacing": [2, "both"],
		"object-curly-spacing": [2, "never", {objectsInObjects: false}],
	}
};
